#include <bits/stdc++.h>

using namespace std;

typedef vector<bool> vb;
typedef vector<vb> vvb;
typedef vector<int> vi;
typedef vector<vi> vvi;

#define PB push_back
#define MAX_VAL 260000

// global variables:
int h, w;
vvb grid;

vvi values;
vvb memo;

// functions:
void input();
int getFieldDist(int row, int col);
void output(int out);


int main()
{
    input();
    int min_dist = getFieldDist(0, 0);
    output(min_dist);

    return 0;
}


int getFieldDist(int row, int col) {
    if (row == h - 1 && col == w - 1) return 0;
    if (row >= h || col >= w) return MAX_VAL;
    if (memo[row][col]) return values[row][col];

    int right, down, diag;  // diag - down right diag
    // mark with MAX for invalid moves:
    right = down = diag = MAX_VAL;  // based on defined limits

    if (col + 1 != w && grid[row][col + 1] == false) {
        right = 1 + getFieldDist(row, col + 1);
    }
    if (row + 1 != h && grid[row + 1][col] == false) {
        down = 1 + getFieldDist(row + 1, col);
    }
    if (row + 1 != h && col + 1 != w && grid[row + 1][col + 1] == false) {
        diag = 1 + getFieldDist(row + 1, col + 1);
    }

    values[row][col] = min(min(down, diag), right);
    memo[row][col] = true;
    return values[row][col];
}


void input() {
    scanf("%d %d", &h, &w);

    string cur;
    for (int i = 0; i < h; ++i) {
        vb cur_row, memo_row;
        vi val_row;
        //getline(cin, cur);
        cin >> cur;
        for (int j = 0; j < w; ++j) {
            if (cur[j] == '.') {
                cur_row.PB(0);  // free
            } else {
                cur_row.PB(1);
            }
            memo_row.PB(0);
            val_row.PB(0);
        }
        grid.PB(cur_row);
        memo.PB(memo_row);
        values.PB(val_row);
    }
}

void output(int out) {
    printf("%d\n", out > 255000 ? -1 : out);
}